<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\System;
use Erlage\Photogram\Response;
use Erlage\Photogram\Constants\ResponseConstants;

/*
|--------------------------------------------------------------------------
| bootstrap autoloader, and config
|--------------------------------------------------------------------------
*/

require __DIR__ . '/../../bootstrap.php';

/*
|--------------------------------------------------------------------------
| start system
|--------------------------------------------------------------------------
*/

System::init(true);

/*
|--------------------------------------------------------------------------
| forward the request to admin api
|--------------------------------------------------------------------------
*/

require DIR_PATH_API . 'admin/stable/entry.php';

/*
|--------------------------------------------------------------------------
| if still not dispatched, this means server doesn't know how to respond
| /or process the request that's received. so let client know about that
| client can let user know about outdated/non-supported client interface
|--------------------------------------------------------------------------
*/

if ( ! State::isDispatched())
{
    Response::instance()
        -> setMessage(ResponseConstants::ERROR_NON_SUPPORTED_REQUEST_MSG)
        -> dispatch();
}
